<?php
require(dirname(__DIR__) . "/main.php");

// 运行状态指令
if (消息 == "运行状态") {
    // 直接调用后端脚本获取运行状态数据
    $apiUrl = "https://bot.xdyyds.cn//admin/api/1main.php";
    $response = file_get_contents($apiUrl);

    if ($response === false) {
        // 获取错误信息
        $error = error_get_last();
        文字("获取运行状态失败，请稍后再试。错误信息：" . $error['message']);
        return;
    }

    // 检查返回内容是否为有效的 JSON
    $data = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        文字("解析运行状态数据失败，请稍后再试。错误信息：" . json_last_error_msg() . "\n原始响应内容：\n" . $response);
        return;
    }

    // 确保关键字段存在，不存在则提供默认值
    $data['昵称'] = isset($data['昵称']) && !empty($data['昵称']) ? $data['昵称'] : "小蛋Bot";

    // 格式化运行状态信息
    $message = "🤖 机器人运行状态 🤖\n\n";
    $message .= "昵称：{$data['昵称']}\n";
    $message .= "ID：{$data['账号']}\n";
    $message .= "日志行数：{$data['日志行数']}\n";
    $message .= "群聊消息：{$data['群聊']}\n";
    $message .= "私聊消息：{$data['私聊']}\n";
    $message .= "加群次数：{$data['加群']}\n";
    $message .= "退群次数：{$data['退群']}\n\n";
    $message .= "已加载插件：{$data['插件数量']}\n";
    $message .= "CPU核心数：{$data['CPU核心数']}\n";
    $message .= "CPU使用率：{$data['CPU使用率']}%\n";
    $message .= "内存使用率：{$data['内存使用率']}%\n";
    $message .= "存储使用率：{$data['存储使用率']}%\n";
    $message .= "操作系统：{$data['操作系统']}\n";
    $message .= "运行时间：{$data['服务器运行时间']}";

    // 根据菜单模式发送信息
    $cdms = 读('月神/配置/菜单模式', 来源, $raw);
    if ($cdms == '文卡模式') {
        文卡(["text" => $message], ["text" => "", "url" => ""]);
    } elseif ($cdms == '文字模式') {
        文字($message);
    } else {
        写('月神/配置/菜单模式', 来源, '文字模式');
        文字($message);
    }
}
