<?php
if (消息来源 == "群聊") {
    // 点歌功能（只存储歌名）
    if (前缀(消息, "点歌")) {
        $songName = 前缀后(消息, "点歌");
        if (empty($songName)) {
            文字("请告诉我你想听的歌曲名称！");
            return;
        }
        
        $apiUrl = "https://api.vkeys.cn/v2/music/netease?word=" . urlencode($songName);
        $apiResult = curl($apiUrl, "GET", "", "");
        $data = json_decode($apiResult, true);
        
        if ($data["code"] != 200 || empty($data["data"])) {
            文字("歌曲搜索失败，请稍后再试");
            return;
        }
        
        $songList = $data["data"];
        $reply = "搜索『" . $songName . "』结果：\n（使用“我要听+序号”进行播放）\n\n";
        
        $index = 1;
        foreach ($songList as $song) {
            $time = isset($song["time"]) ? $song["time"] : "未知时间";
            $reply .= $index . ". " . $song["song"] . 
                      "\n---" . $song["singer"] . 
                      "\n发布时间：" . $time . "\n\n";
            $index++;
        }
        文字($reply);
        
        写("user_search.json", 用户, $songName);
    }
    
    if (前缀(消息,"我要听")) {
        $selection = 前缀后(消息, "我要听");
        if ($selection < 1 || $selection > 10) {
            文字("请输入1-10之间的数字选择歌曲");
            return;
        }
        
        $songName = 读("user_search.json", 用户, "");
        if (empty($songName)) {
            文字("请先使用「点歌+歌名」搜索歌曲");
            return;
        }
        $playUrlApi = "https://api.vkeys.cn/v2/music/netease?word=".urlencode($songName)."&choose=".$selection;
        $playResult = curl($playUrlApi, "GET", "", "");
        $playData = json_decode($playResult, true);

        if (!isset($playData["code"]) || $playData["code"] != 200 || empty($playData["data"]["url"])) {
            文字("获取歌曲失败：可能序号无效或歌曲不可用");
            return;
        }
        $songData = $playData["data"];
        $time = isset($songData["time"]) ? $songData["time"] : "未知时间";
        
        文字("正在缓存请稍等....：\n🎵 " . $songData["song"] . 
             "\n🎤 " . $songData["singer"] . 
             "\n⏱️ " . $songData["interval"]);
        
        语音($songData["url"]);
    }
}