<?php
require("header.php");
?>

<div class="settings-container">
    <div class="settings-title">账号设置</div>
    
    <form id="settings-form" action="api/login.php" method="post">
        <input type="hidden" name="type" value="set">
        
        <div class="input-group">
            <label for="admin">管理员账号</label>
            <input type="text" id="admin" name="admin" placeholder="请输入新的管理员账号" required>
        </div>
        
        <div class="input-group">
            <label for="password">管理员密码</label>
            <input type="password" id="password" name="password" placeholder="请输入新的管理员密码" required>
        </div>
        
        <button type="submit" class="save-btn">保存设置</button>
    </form>
</div>

<!-- 优化后的弹窗 -->
<div class="modal" id="result-modal">
    <div class="modal-content">
        <div class="modal-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                <polyline points="22 4 12 14.01 9 11.01"></polyline>
            </svg>
        </div>
        <div class="modal-title" id="modal-title">操作成功</div>
        <div class="modal-message" id="modal-message"></div>
        <button class="modal-btn" id="modal-btn">
            <span>确认</span>
        </button>
    </div>
</div>

<script>
document.getElementById('settings-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.textContent;
    
    // 添加加载状态
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<span class="loading-spinner"></span> 保存中...';
    
    fetch(this.action, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        const modal = document.getElementById('result-modal');
        const modalTitle = document.getElementById('modal-title');
        const modalMessage = document.getElementById('modal-message');
        const modalIcon = document.querySelector('.modal-icon svg');
        
        if(data.code === 200) {
            modalTitle.textContent = '操作成功';
            modalMessage.textContent = data.msg;
            modalIcon.innerHTML = `
                <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                <polyline points="22 4 12 14.01 9 11.01"></polyline>
            `;
        } else {
            modalTitle.textContent = '操作失败';
            modalMessage.textContent = data.msg;
            modalIcon.innerHTML = `
                <circle cx="12" cy="12" r="10"></circle>
                <line x1="12" y1="8" x2="12" y2="12"></line>
                <line x1="12" y1="16" x2="12.01" y2="16"></line>
            `;
        }
        
        modal.classList.add('active');
        
        document.getElementById('modal-btn').addEventListener('click', function() {
            modal.classList.remove('active');
            if(data.code === 200) {
                // 可以在这里添加成功后的操作
            }
        });
    })
    .catch(error => {
        console.error('Error:', error);
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.textContent = originalBtnText;
    });
});
</script>

<style>
/* 设置容器样式 */
.settings-container {
    background-color: white;
    border-radius: 12px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    padding: 40px;
    width: 350px;
    transform: translateY(0);
    opacity: 1;
    animation: fadeIn 0.5s ease-out forwards;
    margin: 0 auto;
}

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* 标题样式 */
.settings-title {
    text-align: center;
    margin-bottom: 30px;
    color: #333;
    font-size: 24px;
    font-weight: 600;
}

/* 输入框样式 */
.input-group {
    margin-bottom: 20px;
    position: relative;
}

.input-group label {
    display: block;
    margin-bottom: 8px;
    color: #555;
    font-size: 14px;
    font-weight: 500;
}

.input-group input {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-size: 15px;
    transition: all 0.3s;
}

.input-group input:focus {
    border-color: #a0c4ff;
    outline: none;
    box-shadow: 0 0 0 3px rgba(160, 196, 255, 0.2);
}

/* 保存按钮样式 */
.save-btn {
    width: 100%;
    padding: 12px;
    background-color: #4a90e2;
    color: white;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    margin-top: 10px;
    position: relative;
    overflow: hidden;
}

.save-btn:hover {
    background-color: #3a7bc8;
}

.save-btn:active {
    transform: scale(0.98);
}

.save-btn .loading-spinner {
    display: inline-block;
    width: 14px;
    height: 14px;
    border: 2px solid rgba(255,255,255,0.3);
    border-radius: 50%;
    border-top-color: white;
    animation: spin 1s ease-in-out infinite;
    margin-right: 8px;
    vertical-align: middle;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* 弹窗样式 */
.modal {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(0, 0, 0, 0.4);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1000;
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s ease-out;
    backdrop-filter: blur(5px);
}

.modal.active {
    opacity: 1;
    pointer-events: all;
}

.modal-content {
    background-color: white;
    padding: 30px;
    border-radius: 16px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    width: 320px;
    text-align: center;
    transform: scale(0.9) translateY(20px);
    opacity: 0;
    transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
}

.modal.active .modal-content {
    transform: scale(1) translateY(0);
    opacity: 1;
}

.modal-icon {
    margin: 0 auto 15px;
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: #e6f2ff;
    border-radius: 50%;
}

.modal-icon svg {
    color: #4a90e2;
    width: 32px;
    height: 32px;
}

.modal-title {
    font-size: 20px;
    margin-bottom: 10px;
    color: #333;
    font-weight: 600;
}

.modal-message {
    font-size: 15px;
    color: #666;
    margin-bottom: 25px;
    line-height: 1.5;
}

.modal-btn {
    position: relative;
    padding: 12px 24px;
    background-color: #e6f2ff;
    color: #4a90e2;
    border: none;
    border-radius: 8px;
    font-size: 15px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    overflow: hidden;
    min-width: 120px;
}

.modal-btn:hover {
    background-color: #d4e7ff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(74, 144, 226, 0.2);
}

.modal-btn:active {
    transform: translateY(0);
    box-shadow: 0 2px 6px rgba(74, 144, 226, 0.2);
}

.modal-btn span {
    position: relative;
    z-index: 1;
}

.modal-btn::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(to right, rgba(255,255,255,0.2), rgba(255,255,255,0.1));
    transform: translateX(-100%);
    transition: transform 0.3s ease;
}

.modal-btn:hover::after {
    transform: translateX(0);
}
</style>

<?php
require("footer.php");
?>