<?php
require("header.php");
?>

 <div class="plugin-container">
    <!-- 插件操作卡片 -->
    <div class="plugin-card control-card">
        <div class="plugin-header">
            <div class="plugin-icon">
                <i class="fas fa-list"></i>
            </div>
            <div class="plugin-name">插件列表</div>
        </div>
        <button class="plugin-btn create-btn" id="createPluginBtn">
            <i class="fas fa-plus"></i> 创建插件
        </button>
    </div>
    
    <!-- 插件列表容器 -->
    <div id="pluginListContainer" class="plugin-grid"></div>
</div>

<!-- 创建插件弹窗 -->
<div id="createModal" class="plugin-modal">
    <div class="modal-content">
        <h3>创建新插件</h3>
        <div class="form-group">
            <label for="pluginName">插件名称</label>
            <input type="text" id="pluginName" class="form-input" placeholder="请输入插件名称">
        </div>
        <div class="modal-buttons">
            <button class="modal-btn cancel-btn">取消</button>
            <button class="modal-btn confirm-btn">创建</button>
        </div>
    </div>
</div>

<!-- 编辑器页面 -->
<div id="editorContainer" style="display: none;">
    <div class="editor-header">
        <div class="editor-icon">
            <i class="fas fa-puzzle-piece"></i>
        </div>
        <div class="editor-name" id="editorPluginName">插件编辑器</div>
    </div>
    
    <div class="editor-body">
        <div class="editor-tabs">
            <button class="tab-btn active" data-tab="editor">编辑器</button>
            <button class="tab-btn" data-tab="preview">预览</button>
        </div>
        
        <div class="editor-content">
            <div class="tab-pane active" id="editorPane">
                <textarea id="pluginEditor" class="code-editor"></textarea>
            </div>
            <div class="tab-pane" id="previewPane">
                <pre id="pluginPreview"></pre>
            </div>
        </div>
    </div>
    
    <div class="editor-footer">
        <button id="savePluginBtn" class="plugin-btn save-btn">
            <i class="fas fa-save"></i> 保存
        </button>
    </div>
</div>

<style>
    /* 插件容器样式 */
    .plugin-container {
        max-width: 1200px;
        margin: 20px auto;
        padding: 20px;
    }
    
    /* 插件网格布局 */
    .plugin-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 15px;
        margin-top: 20px;
    }
    
    /* 插件卡片样式 */
    .plugin-card {
        background-color: white;
        border-radius: 12px;
        padding: 15px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transition: transform 0.2s, box-shadow 0.2s;
        cursor: pointer;
        display: flex;
        flex-direction: column;
    }
    
    .plugin-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.12);
    }
    
    /* 控制卡片样式 */
    .control-card {
        grid-column: 1 / -1;
        flex-direction: row;
        align-items: center;
        justify-content: space-between;
    }
    
    /* 插件头部样式 */
    .plugin-header, .editor-header {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }
    
    /* 插件图标样式 */
    .plugin-icon, .editor-icon {
        width: 40px;
        height: 40px;
        background-color: #f0f8ff;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
    }
    
    .plugin-icon i, .editor-icon i {
        font-size: 18px;
        color: #4da6ff;
    }
    
    /* 插件名称样式 */
    .plugin-name, .editor-name {
        font-size: 16px;
        font-weight: bold;
        flex: 1;
    }
    
    /* 插件操作按钮容器 */
    .plugin-actions {
        display: flex;
        flex-direction: column;
        gap: 5px;
        margin-left: 10px;
    }
    
    /* 操作按钮样式 */
    .plugin-action-btn {
        padding: 4px 8px;
        border: none;
        border-radius: 4px;
        font-size: 12px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 50px;
        transition: all 0.3s;
    }
    
    .edit-action-btn {
        background-color: #4da6ff;
        color: white;
    }
    
    .edit-action-btn:hover {
        background-color: #3a8bd9;
    }
    
    .delete-action-btn {
        background-color: #ff6b6b;
        color: white;
    }
    
    .delete-action-btn:hover {
        background-color: #e05555;
    }
    
    /* 插件按钮样式 */
    .plugin-btn {
        padding: 8px 15px;
        border: none;
        border-radius: 6px;
        font-size: 14px;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 5px;
        transition: all 0.3s;
    }
    
    .create-btn {
        background-color: #4da6ff;
        color: white;
    }
    
    .create-btn:hover {
        background-color: #3a8bd9;
    }
    
    .save-btn {
        background-color: #4da6ff;
        color: white;
        padding: 10px 20px;
        font-size: 16px;
        border-radius: 8px;
    }
    
    .save-btn:hover {
        background-color: #3a8bd9;
    }
    
    /* 弹窗样式 */
    .plugin-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 2000;
        justify-content: center;
        align-items: center;
    }
    
    .modal-content {
        background-color: white;
        padding: 20px;
        border-radius: 12px;
        width: 400px;
        max-width: 90%;
    }
    
    .modal-content h3 {
        margin-top: 0;
        margin-bottom: 20px;
    }
    
    /* 编辑器样式 */
    #editorContainer {
        max-width: 1200px;
        margin: 20px auto;
        padding: 20px;
    }
    
    .editor-body {
        background-color: white;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        margin-bottom: 15px;
    }
    
    .editor-tabs {
        display: flex;
        border-bottom: 1px solid #eee;
    }
    
    .tab-btn {
        padding: 10px 20px;
        background: none;
        border: none;
        cursor: pointer;
        font-size: 14px;
        color: #666;
        position: relative;
    }
    
    .tab-btn.active {
        color: #4da6ff;
        font-weight: bold;
    }
    
    .tab-btn.active::after {
        content: '';
        position: absolute;
        bottom: -1px;
        left: 0;
        right: 0;
        height: 2px;
        background-color: #4da6ff;
    }
    
    .tab-pane {
        display: none;
        padding: 15px;
    }
    
    .tab-pane.active {
        display: block;
    }
    
    .code-editor {
        width: 100%;
        height: 500px;
        padding: 15px;
        border: none;
        font-family: 'Courier New', Courier, monospace;
        font-size: 14px;
        line-height: 1.5;
        resize: none;
        outline: none;
        background-color: #f8f9fa;
        border-radius: 0 0 8px 8px;
    }
    
    #pluginPreview {
        width: 100%;
        height: 500px;
        padding: 15px;
        overflow: auto;
        background-color: #f8f9fa;
        border-radius: 0 0 8px 8px;
        white-space: pre-wrap;
    }
    
    .editor-footer {
        text-align: right;
    }
    
    /* 表单样式 */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: bold;
    }
    
    .form-input {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 6px;
        font-size: 16px;
    }
    
    .modal-buttons {
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }
    
    .modal-btn {
        padding: 8px 15px;
        border: none;
        border-radius: 6px;
        font-size: 14px;
        cursor: pointer;
    }
    
    .cancel-btn {
        background-color: #f0f0f0;
    }
    
    .cancel-btn:hover {
        background-color: #e0e0e0;
    }
    
    .confirm-btn {
        background-color: #4da6ff;
        color: white;
    }
    
    .confirm-btn:hover {
        background-color: #3a8bd9;
    }
</style>

<script>
    // 全局变量
    let currentPlugin = '';
    
    // 页面加载时初始化
    document.addEventListener('DOMContentLoaded', function() {
        // 检查URL参数，判断是否进入编辑模式
        const urlParams = new URLSearchParams(window.location.search);
        const pluginName = urlParams.get('name');
        
        if (pluginName) {
            // 进入编辑模式
            enterEditMode(pluginName);
        } else {
            // 显示插件列表
            loadPluginList();
        }
        
        // 绑定事件
        bindEvents();
    });
    
    // 绑定事件
    function bindEvents() {
        // 创建插件按钮
        document.getElementById('createPluginBtn').addEventListener('click', function() {
            document.getElementById('createModal').style.display = 'flex';
        });
        
        // 创建插件弹窗取消按钮
        document.querySelector('#createModal .cancel-btn').addEventListener('click', function() {
            document.getElementById('createModal').style.display = 'none';
        });
        
        // 创建插件弹窗确认按钮
        document.querySelector('#createModal .confirm-btn').addEventListener('click', function() {
            const pluginName = document.getElementById('pluginName').value.trim();
            
            if (!pluginName) {
                alert('请输入插件名称');
                return;
            }
            
            createPlugin(pluginName);
        });
        
        // 标签切换
        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const tab = this.dataset.tab;
                switchTab(tab);
            });
        });
        
        // 保存插件按钮
        document.getElementById('savePluginBtn').addEventListener('click', savePlugin);
        
        // 编辑器内容变化时更新预览
        document.getElementById('pluginEditor').addEventListener('input', function() {
            updatePreview();
        });
    }
    
    // 加载插件列表
    function loadPluginList() {
        fetch('api/plugin.php?type=list')
            .then(response => response.json())
            .then(data => {
                if (data.code === 200) {
                    renderPluginList(data.list);
                } else {
                    alert('获取插件列表失败');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('获取插件列表时出错');
            });
    }
    
    // 渲染插件列表
    function renderPluginList(plugins) {
        const container = document.getElementById('pluginListContainer');
        container.innerHTML = '';
        
        plugins.forEach(plugin => {
            const card = document.createElement('div');
            card.className = 'plugin-card';
            card.dataset.plugin = plugin;
            
            card.innerHTML = `
                <div class="plugin-header">
                    <div class="plugin-icon">
                        <i class="fas fa-puzzle-piece"></i>
                    </div>
                    <div class="plugin-name">${plugin}</div>
                    <div class="plugin-actions">
                        <button class="plugin-action-btn edit-action-btn" data-plugin="${plugin}">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="plugin-action-btn delete-action-btn" data-plugin="${plugin}">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            `;
            
            container.appendChild(card);
        });
        
        // 绑定操作按钮事件
        document.querySelectorAll('.edit-action-btn').forEach(btn => {
            btn.addEventListener('click', function(e) {
                e.stopPropagation();
                const pluginName = this.dataset.plugin;
                window.location.href = `plugin.php?name=${pluginName}`;
            });
        });
        
        document.querySelectorAll('.delete-action-btn').forEach(btn => {
            btn.addEventListener('click', function(e) {
                e.stopPropagation();
                const pluginName = this.dataset.plugin;
                if (confirm(`确定要删除插件 "${pluginName}" 吗？`)) {
                    deletePlugin(pluginName);
                }
            });
        });
    }
    
    // 创建插件
    function createPlugin(pluginName) {
        const formData = new FormData();
        formData.append('type', 'add');
        formData.append('name', pluginName);
        
        fetch('api/plugin.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.code === 200) {
                alert('插件创建成功');
                document.getElementById('createModal').style.display = 'none';
                document.getElementById('pluginName').value = '';
                loadPluginList();
            } else {
                alert(data.msg || '插件创建失败');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('创建插件时出错');
        });
    }
    
    // 删除插件
    function deletePlugin(pluginName) {
        const formData = new FormData();
        formData.append('type', 'delete');
        formData.append('name', pluginName);
        
        fetch('api/plugin.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.code === 200) {
                alert('插件删除成功');
                loadPluginList();
            } else {
                alert(data.msg || '插件删除失败');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('删除插件时出错');
        });
    }
    
    // 进入编辑模式
    function enterEditMode(pluginName) {
        currentPlugin = pluginName;
        
        // 显示编辑器，隐藏列表
        document.querySelector('.plugin-container').style.display = 'none';
        document.getElementById('editorContainer').style.display = 'block';
        
        // 设置插件名称
        document.getElementById('editorPluginName').textContent = pluginName;
        
        // 加载插件内容
        loadPluginContent(pluginName);
    }
    
    // 加载插件内容
    function loadPluginContent(pluginName) {
        fetch(`api/plugin.php?type=read&name=${pluginName}`)
            .then(response => response.json())
            .then(data => {
                if (data.code === 200) {
                    document.getElementById('pluginEditor').value = data.msg;
                    updatePreview();
                } else {
                    alert(data.msg || '读取插件内容失败');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('读取插件内容时出错');
            });
    }
    
    // 保存插件
    function savePlugin() {
        const content = document.getElementById('pluginEditor').value;
        
        fetch(`api/plugin.php?type=write&name=${currentPlugin}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                content: content
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.code === 200) {
                alert('插件保存成功');
            } else {
                alert(data.msg || '插件保存失败');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('保存插件时出错');
        });
    }
    
    // 切换标签页
    function switchTab(tab) {
        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.classList.toggle('active', btn.dataset.tab === tab);
        });
        
        document.querySelectorAll('.tab-pane').forEach(pane => {
            pane.classList.toggle('active', pane.id === `${tab}Pane`);
        });
    }
    
    // 更新预览
    function updatePreview() {
        const content = document.getElementById('pluginEditor').value;
        document.getElementById('pluginPreview').textContent = content;
    }
</script>

<?php
require("footer.php");
?>