<?php
require("header.php");
?>

    <div class="dashboard-container">
        <!-- 卡片1: 用户资料 -->
        <div class="dashboard-card profile-card">
            <img id="user-avatar" src="" alt="头像" class="avatar">
            <div class="profile-info">
                <h3 id="user-nickname"></h3>
                <p id="user-id"></p>
            </div>
        </div>
        <!-- 卡片2: 插件和日志 -->
<div class="dashboard-card stats-card">
    <div class="stats-grid">
        <div class="stat-item">
            <i class="fas fa-puzzle-piece stat-icon" style="color: #4CAF50;"></i>
            <div class="stat-text">
                <p class="stat-label">插件</p>
                <p id="plugin-count" class="stat-value">0</p>
            </div>
            <i class="fas fa-clipboard-list stat-icon" style="color: #2196F3;"></i>
            <div class="stat-text">
                <p class="stat-label">日志</p>
                <p id="log-count" class="stat-value">0</p>
            </div>
        </div>
        
        <div class="stat-item">
            <i class="fas fa-comments stat-icon" style="color: #FF5722;"></i>
            <div class="stat-text">
                <p class="stat-label">群聊</p>
                <p id="group-chat" class="stat-value">0</p>
            </div>
            <i class="fas fa-user stat-icon" style="color: #E91E63;"></i>
            <div class="stat-text">
                <p class="stat-label">私聊</p>
                <p id="private-chat" class="stat-value">0</p>
            </div>
        </div>
        
        <div class="stat-item">
            <i class="fas fa-user-plus stat-icon" style="color: #8BC34A;"></i>
            <div class="stat-text">
                <p class="stat-label">加群</p>
                <p id="group-join" class="stat-value">0</p>
            </div>
            <i class="fas fa-user-minus stat-icon" style="color: #F44336;"></i>
            <div class="stat-text">
                <p class="stat-label">退群</p>
                <p id="group-leave" class="stat-value">0</p>
            </div>
        </div>
    </div>
</div>

        <!-- 卡片3: CPU使用率 -->
        <div class="dashboard-card">
            <div class="card-header">
                <i class="fas fa-microchip card-icon cpu-icon"></i>
                <span id="cpu-title">CPU(加载中...)</span>
            </div>
            <div class="progress-bar">
                <div id="cpu-bar" class="progress-fill"></div>
            </div>
            <p id="cpu-usage" class="progress-text"></p>
        </div>

        <!-- 卡片4: 内存使用率 -->
        <div class="dashboard-card">
            <div class="card-header">
                <i class="fas fa-memory card-icon memory-icon"></i>
                <span>内存使用率</span>
            </div>
            <div class="progress-bar">
                <div id="memory-bar" class="progress-fill"></div>
            </div>
            <p id="memory-usage" class="progress-text"></p>
        </div>

        <!-- 卡片5: 存储使用情况 -->
        <div class="dashboard-card">
            <div class="card-header">
                <i class="fas fa-hdd card-icon storage-icon"></i>
                <span>存储空间</span>
            </div>
            <div class="progress-bar">
                <div id="storage-bar" class="progress-fill"></div>
            </div>
            <p id="storage-info" class="progress-text"></p>
        </div>

        <!-- 卡片6: 系统信息 -->
        <div class="dashboard-card system-card">
            <div class="system-info">
                <i class="fas fa-desktop system-icon"></i>
                <span id="os-info">加载中...</span>
            </div>
            <div class="system-info">
                <i class="fas fa-clock system-icon"></i>
                <span id="uptime-info">加载中...</span>
            </div>
        </div>
    </div>
</main>

<style>
    /* 主内容区域 */
    .main-content {
        padding: 20px;
        margin-top: 60px;
        width: 100%;
        box-sizing: border-box;
    }

    /* 仪表板容器 */
    .dashboard-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
        max-width: 1300px;
        margin: 0 auto;
        padding: 0 10px;
    }

    /* 卡片通用样式 */
    .dashboard-card {
        background: white;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .dashboard-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
    }

    /* 个人资料卡片 */
    .profile-card {
        display: flex;
        align-items: center;
        gap: 20px;
    }

    .avatar {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        object-fit: cover;
    }

    .profile-info h3 {
        margin-bottom: 5px;
        font-size: 1.2rem;
    }

    .profile-info p {
        color: #666;
        font-size: 0.9rem;
    }
    /* 统计卡片 */
.stats-card {
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.stats-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
}

.stat-item {
    display: flex;
    align-items: center;
    gap: 12px;
}

.stat-icon {
    font-size: 20px;
    width: 24px;
    text-align: center;
}

.stat-text {
    flex: 1;
}

.stat-label {
    font-size: 0.85rem;
    color: #666;
    margin-bottom: 2px;
}

.stat-value {
    font-size: 1.2rem;
    font-weight: bold;
    margin: 0;
}

/* 黑暗模式适配 */
.dark-mode .stat-label {
    color: #aaa;
}

@media (max-width: 768px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
}

    /* 卡片头部 */
    .card-header {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 15px;
    }

    .card-icon {
        font-size: 1.3rem;
    }

    .cpu-icon { color: #FF9800; }
    .memory-icon { color: #9C27B0; }
    .storage-icon { color: #607D8B; }

    /* 进度条 */
    .progress-bar {
        background: #f0f0f0;
        height: 10px;
        border-radius: 5px;
        overflow: hidden;
        margin-bottom: 5px;
    }

    .progress-fill {
        height: 100%;
        width: 0%;
        transition: width 0.5s ease;
    }

    #cpu-bar { background: #FF9800; }
    #memory-bar { background: #9C27B0; }
    #storage-bar { background: #607D8B; }

    .progress-text {
        text-align: right;
        font-size: 0.8rem;
        color: #666;
    }

    /* 系统信息卡片 */
    .system-card {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .system-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .system-icon {
        font-size: 1.3rem;
        color: #795548;
    }

    /* 黑暗模式适配 */
    .dark-mode .dashboard-card {
        background: #2d2d2d;
        box-shadow: 0 4px 8px rgba(0,0,0,0.3);
    }

    .dark-mode .profile-info p,
    .dark-mode .stat-label,
    .dark-mode .progress-text {
        color: #aaa;
    }

    .dark-mode .progress-bar {
        background: #3d3d3d;
    }

    @media (max-width: 768px) {
        .dashboard-container {
            grid-template-columns: 1fr;
            padding: 0 15px;
        }
        
        .stats-row {
            flex-direction: column;
            gap: 15px;
        }
    }
</style>

<script>
// 获取数据并更新页面
function fetchData() {
    fetch('api/main.php')
        .then(response => response.json())
        .then(data => {
            // 更新用户资料
            document.getElementById('user-avatar').src = data['头像'];
            document.getElementById('user-nickname').textContent = data['昵称'];
            document.getElementById('user-id').textContent = data['账号'];
            
            // 更新插件和日志
            document.getElementById('plugin-count').textContent = data['插件数量'];
            document.getElementById('log-count').textContent = data['日志行数'];
            
            // 更新聊天统计数据
            document.getElementById('group-chat').textContent = data['群聊'];
            document.getElementById('private-chat').textContent = data['私聊'];
            document.getElementById('group-join').textContent = data['加群'];
            document.getElementById('group-leave').textContent = data['退群'];
            
            // 更新CPU信息
            document.getElementById('cpu-title').textContent = `CPU(${data['CPU核心数']}核)`;
            document.getElementById('cpu-bar').style.width = `${data['CPU使用率']}%`;
            document.getElementById('cpu-usage').textContent = `${data['CPU使用率']}%`;
            
            // 更新内存信息
            document.getElementById('memory-bar').style.width = `${data['内存使用率']}%`;
            document.getElementById('memory-usage').textContent = `${data['内存使用率']}%`;
            
            // 更新存储信息
            document.getElementById('storage-bar').style.width = `${data['存储使用率']}%`;
            document.getElementById('storage-info').textContent = `${data['使用存储']}/${data['总存储']} (${data['存储使用率']}%)`;
            
            // 更新系统信息
            document.getElementById('os-info').textContent = data['操作系统'];
            document.getElementById('uptime-info').textContent = `运行时间: ${data['服务器运行时间']}`;
        })
        .catch(error => {
            console.error('获取数据失败:', error);
        });
}

// 页面加载时获取数据
document.addEventListener('DOMContentLoaded', fetchData);

// 每30秒刷新一次数据
setInterval(fetchData, 30000);
</script>

<?php
require("footer.php");
?>