<?php
if (isset($_COOKIE['admin_token'])) {
    header("Location: main.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QQBot-PHP框架</title>
    <style>
        /* 基础样式 */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }
        
        body {
            background-color: #f5f5f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            overflow: hidden;
        }
        
        /* 卡片容器 - 初始状态在屏幕下方 */
        .login-container {
            background-color: white;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            padding: 40px;
            width: 380px;
            transform: translateY(100vh);
            opacity: 0;
            animation: slideUp 0.6s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
        }
        
        /* 卡片弹出动画 */
        @keyframes slideUp {
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        /* 标题样式 */
        .login-title {
            text-align: center;
            margin-bottom: 30px;
            color: #333;
            font-size: 24px;
            font-weight: 600;
        }
        
        /* 输入框样式 */
        .input-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .input-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-size: 14px;
            font-weight: 500;
        }
        
        .input-group input {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 15px;
            transition: all 0.3s;
        }
        
        .input-group input:focus {
            border-color: #a0c4ff;
            outline: none;
            box-shadow: 0 0 0 3px rgba(160, 196, 255, 0.2);
        }
        
        /* 登录按钮样式 */
        .login-btn {
            width: 100%;
            padding: 12px;
            background-color: #d4e3ff;
            color: #2a6df5;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .login-btn:hover {
            background-color: #c2d7ff;
        }
        
        .login-btn:active {
            transform: scale(0.98);
        }
        
        /* 弹窗样式 */
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s;
        }
        
        .modal.active {
            opacity: 1;
            pointer-events: all;
        }
        
        .modal-content {
            background-color: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            max-width: 350px;
            width: 90%;
            text-align: center;
            transform: translateY(20px);
            transition: transform 0.3s;
        }
        
        .modal.active .modal-content {
            transform: translateY(0);
        }
        
        .modal-title {
            font-size: 18px;
            margin-bottom: 15px;
            color: #333;
        }
        
        .modal-message {
            font-size: 15px;
            color: #555;
            margin-bottom: 20px;
        }
        
        .modal-btn {
            padding: 8px 20px;
            background-color: #d4e3ff;
            color: #2a6df5;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .modal-btn:hover {
            background-color: #c2d7ff;
        }
    </style>
</head>
<body>
    <!-- 登录卡片 -->
    <div class="login-container">
        <h1 class="login-title">QQBot-PHP框架</h1>
        <form id="loginForm">
            <div class="input-group">
                <label for="admin">账号</label>
                <input type="text" id="admin" name="admin" placeholder="请输入管理员账号" required>
            </div>
            <div class="input-group">
                <label for="password">密码</label>
                <input type="password" id="password" name="password" placeholder="请输入密码" required>
            </div>
            <button type="submit" class="login-btn">登录</button>
        </form>
    </div>
    
    <!-- 弹窗 -->
    <div class="modal" id="modal">
        <div class="modal-content">
            <h3 class="modal-title" id="modalTitle">提示</h3>
            <p class="modal-message" id="modalMessage">这里是消息内容</p>
            <button class="modal-btn" id="modalBtn">确定</button>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            const modal = document.getElementById('modal');
            const modalTitle = document.getElementById('modalTitle');
            const modalMessage = document.getElementById('modalMessage');
            const modalBtn = document.getElementById('modalBtn');
            
            // 显示弹窗函数
            function showModal(title, message, callback) {
                modalTitle.textContent = title;
                modalMessage.textContent = message;
                modal.classList.add('active');
                
                modalBtn.onclick = function() {
                    modal.classList.remove('active');
                    if (typeof callback === 'function') {
                        callback();
                    }
                };
            }
            
            // 登录表单提交
            loginForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const admin = document.getElementById('admin').value.trim();
                const password = document.getElementById('password').value.trim();
                
                if (!admin || !password) {
                    showModal('错误', '请输入账号和密码');
                    return;
                }
                
                // 发送登录请求
                const formData = new FormData();
                formData.append('type', 'login');
                formData.append('admin', admin);
                formData.append('password', password);
                
                fetch('api/login.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.code === 200) {
                        showModal('成功', data.msg, function() {
                            // 登录成功，设置cookie并跳转
                            const expires = new Date();
                            expires.setTime(expires.getTime() + 7 * 24 * 60 * 60 * 1000);
                            document.cookie = `admin_token=${admin}; expires=${expires.toUTCString()}; path=/`;
                            window.location.href = 'main.php';
                        });
                    } else {
                        showModal('错误', data.msg);
                    }
                })
                .catch(error => {
                    showModal('错误', '网络请求失败: ' + error.message);
                });
            });
        });
    </script>
</body>
</html>