<?php
require("header.php");
?>

<div class="content-container">
    <h2>账号管理</h2>
    
    <div class="form-container">
        <div class="form-group">
            <label for="appid">AppID</label>
            <input type="text" id="appid" class="form-input" placeholder="请输入AppID">
        </div>
        
        <div class="form-group">
            <label for="secret">Secret</label>
            <input type="text" id="secret" class="form-input" placeholder="请输入Secret">
        </div>
        
        <div class="form-group">
            <label for="type">环境类型</label>
            <input type="text" id="type" class="form-input" placeholder="请选择环境类型" readonly>
        </div>
        
        <button id="saveBtn" class="save-btn">保存</button>
    </div>
</div>

<!-- 环境类型选择弹窗 -->
<div id="typeModal" class="modal">
    <div class="modal-content">
        <h3>选择环境类型</h3>
        <div class="modal-options">
            <div class="option" data-value="正式">正式环境</div>
            <div class="option" data-value="沙箱">沙箱环境</div>
        </div>
        <button class="modal-close">关闭</button>
    </div>
</div>

<style>
    /* 内容容器样式 */
    .content-container {
        max-width: 800px;
        margin: 20px auto;
        padding: 20px;
        background-color: white;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    
    /* 表单容器样式 */
    .form-container {
        margin-top: 20px;
    }
    
    /* 表单组样式 */
    .form-group {
        margin-bottom: 20px;
    }
    
    /* 表单标签样式 */
    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: bold;
    }
    
    /* 输入框样式 */
    .form-input {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 16px;
    }
    
    /* 保存按钮样式 */
    .save-btn {
        background-color: #4da6ff;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 4px;
        font-size: 16px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    
    .save-btn:hover {
        background-color: #3a8bd9;
    }
    
    /* 弹窗样式 */
    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 2000;
        justify-content: center;
        align-items: center;
    }
    
    .modal-content {
        background-color: white;
        padding: 20px;
        border-radius: 8px;
        width: 300px;
    }
    
    .modal-options {
        margin: 20px 0;
    }
    
    .option {
        padding: 10px;
        margin: 5px 0;
        background-color: #f5f5f5;
        border-radius: 4px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    
    .option:hover {
        background-color: #e0e0e0;
    }
    
    .modal-close {
        background-color: #4da6ff;
        color: white;
        border: none;
        padding: 8px 15px;
        border-radius: 4px;
        cursor: pointer;
    }
</style>

<script>
    // 页面加载时获取当前设置
    document.addEventListener('DOMContentLoaded', function() {
        fetchCurrentSettings();
        
        // 环境类型输入框点击事件
        document.getElementById('type').addEventListener('click', function() {
            document.getElementById('typeModal').style.display = 'flex';
        });
        
        // 弹窗选项点击事件
        document.querySelectorAll('.option').forEach(option => {
            option.addEventListener('click', function() {
                document.getElementById('type').value = this.dataset.value;
                document.getElementById('typeModal').style.display = 'none';
            });
        });
        
        // 关闭弹窗按钮
        document.querySelector('.modal-close').addEventListener('click', function() {
            document.getElementById('typeModal').style.display = 'none';
        });
        
        // 保存按钮点击事件
        document.getElementById('saveBtn').addEventListener('click', saveSettings);
    });
    
    // 获取当前设置
    function fetchCurrentSettings() {
        fetch('api/id.php?type=获取')
            .then(response => response.json())
            .then(data => {
                if (data.code === 200) {
                    document.getElementById('appid').value = data.appid || '';
                    document.getElementById('secret').value = data.secret || '';
                    document.getElementById('type').value = data.type || '';
                } else {
                    alert('获取设置失败');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('获取设置时出错');
            });
    }
    
    // 保存设置
    function saveSettings() {
        const appid = document.getElementById('appid').value;
        const secret = document.getElementById('secret').value;
        const type = document.getElementById('type').value;
        
        if (!appid || !secret || !type) {
            alert('请填写完整信息');
            return;
        }
        
        const formData = new FormData();
        formData.append('type', '更改');
        formData.append('appid', appid);
        formData.append('secret', secret);
        formData.append('id', type);
        
        fetch('api/id.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.code === 200) {
                alert('保存成功');
            } else {
                alert('保存失败');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('保存时出错');
        });
    }
</script>

<?php
require("footer.php");
?>