<?php
// 检查用户是否登录
if (!isset($_COOKIE['admin_token'])) {
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QQBot-PHP框架 Admin</title>
    <style>
        /* 基础样式 */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }
        
        body {
            background-color: #f5f5f5;
            color: #333;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        /* 顶部导航栏 */
        .navbar {
            background-color: white;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
        }
        
        /* 导航按钮 */
        .nav-btn {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: #555;
            padding: 8px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .nav-btn:hover {
            background-color: #f0f0f0;
        }
        
        /* 侧滑栏 */
        .sidebar {
            position: fixed;
            top: 60px;
            left: -250px;
            width: 250px;
            height: calc(100vh - 60px);
            background-color: white;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            transition: left 0.3s ease;
            z-index: 999;
            overflow-y: auto;
        }
        
        .sidebar.open {
            left: 0;
        }
        
        /* 侧滑栏背景图 */
        .sidebar-bg {
            width: 100%;
            height: 150px;
            background-image: url('assets/background.png');
            background-size: cover;
            background-position: center;
        }
        
        /* 侧滑栏菜单项 - 优化后的样式 */
        .menu-item {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            color: #555;
            text-decoration: none;
            border-bottom: 1px solid #eee;
            white-space: nowrap;
        }
        
        .menu-item:hover {
            background-color: #f9f9f9;
        }
        
        .menu-item i {
            margin-right: 15px;
            font-size: 20px;
            width: 24px;
            text-align: center;
        }
        
        .menu-item span {
            flex: 1;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        /* 主要内容区域 */
        .main-content {
            margin-top: 60px;
            flex: 1;
            padding: 20px;
            min-height: calc(100vh - 100px);
        }

        /* 确认对话框样式 */
        .confirm-dialog {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 2000;
            justify-content: center;
            align-items: center;
        }

        .confirm-content {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            width: 300px;
            text-align: center;
        }

        .confirm-buttons {
            margin-top: 20px;
            display: flex;
            justify-content: center;
            gap: 15px;
        }

        .confirm-btn {
            padding: 8px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
        }

        .confirm-btn.cancel {
            background-color: #f0f0f0;
        }

        .confirm-btn.logout {
            background-color: #4da6ff;
            color: white;
        }
    </style>
    <!-- 使用国内BootCDN提供的Font Awesome图标库 -->
    <link rel="stylesheet" href="https://cdn.bootcdn.net/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <!-- 顶部导航栏 -->
    <nav class="navbar">
        <button class="nav-btn" id="sidebarToggle">
            <i class="fas fa-bars"></i>
        </button>
        <h2 style="margin-right: auto;">QQBot-PHP框架 admin</h2>
        <div class="nav-actions" style="display: flex; gap: 10px;">
            <button class="nav-btn" id="logoutBtn">
                <i class="fas fa-sign-out-alt"></i>
            </button>
        </div>
    </nav>
    
    <!-- 侧滑栏 -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-bg"></div>
        <a href="main.php" class="menu-item">
            <i class="fas fa-home"></i>
            <span>首页</span>
        </a>
        <a href="id.php" class="menu-item">
            <i class="fas fa-user"></i>
            <span>账号</span>
        </a>
        <a href="plugin.php" class="menu-item">
            <i class="fas fa-puzzle-piece"></i>
            <span>插件</span>
        </a>
        <a href="log.php" class="menu-item">
            <i class="fas fa-clipboard-list"></i>
            <span>日志</span>
        </a>
        <a href="set.php" class="menu-item">
            <i class="fas fa-cog"></i>
            <span>设置</span>
        </a>
        <a href="doc.php" class="menu-item">
            <i class="fas fa-book"></i>
            <span>文档</span>
        </a>
    </aside>
    
    <!-- 主要内容区域 -->
    <main class="main-content">

    <!-- 退出确认对话框 -->
    <div id="confirmDialog" class="confirm-dialog">
        <div class="confirm-content">
            <h3>确定要退出登录吗？</h3>
            <div class="confirm-buttons">
                <button class="confirm-btn cancel">取消</button>
                <button class="confirm-btn logout">退出</button>
            </div>
        </div>
    </div>

    <script>
        // 侧滑栏切换
        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebar = document.getElementById('sidebar');
        
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('open');
        });
        
        // 退出登录功能
        const logoutBtn = document.getElementById('logoutBtn');
        const confirmDialog = document.getElementById('confirmDialog');
        const cancelBtn = document.querySelector('.confirm-btn.cancel');
        const logoutConfirmBtn = document.querySelector('.confirm-btn.logout');
        
        logoutBtn.addEventListener('click', function() {
            confirmDialog.style.display = 'flex';
        });
        
        cancelBtn.addEventListener('click', function() {
            confirmDialog.style.display = 'none';
        });
        
        logoutConfirmBtn.addEventListener('click', function() {
            // 清除cookie并跳转到登录页
            document.cookie = 'admin_token=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;';
            window.location.href = 'index.php';
        });
        
        // 点击对话框外部关闭
        confirmDialog.addEventListener('click', function(e) {
            if (e.target === confirmDialog) {
                confirmDialog.style.display = 'none';
            }
        });
    </script>