<?php
require("header.php");
require dirname(__DIR__).'/function/Parsedown.php';
$parsedown = new Parsedown();
$markdown = file_get_contents(dirname(__DIR__).'/文档.md');
$html = $parsedown->text($markdown);
?>
  <link rel="stylesheet" href="assets/markdown.css">
  <style>
    .markdown-body {
      box-sizing: border-box;
      min-width: 200px;
      max-width: 100%;
      margin: 0;
      padding: 20px;
      width: 100%;
    }
    
    /* 移除顶部多余间距，紧贴导航栏 */
    .markdown-body:first-child {
      margin-top: 0;
    }
    
    /* 电脑端样式 */
    @media (min-width: 768px) {
      .markdown-body {
        padding: 30px 5%;
      }
    }
    
    /* 平板和手机端样式 */
    @media (max-width: 800px) {
      .markdown-body {
        padding: 15px;
      }
      
      pre {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
      }
      
      table {
        display: block;
        overflow-x: auto;
        white-space: nowrap;
      }
    }
    
    /* 超小屏幕手机样式 */
    @media (max-width: 480px) {
      .markdown-body {
        padding: 10px;
        font-size: 14px;
      }
      
      h1 {
        font-size: 1.8em;
        margin-top: 0.5em;
      }
      
      h2 {
        font-size: 1.5em;
      }
      
      img {
        max-width: 100%;
        height: auto;
      }
    }
  </style>
  <div class="markdown-body">
    <?= $html ?>
  </div>
<?php
require("footer.php");