<?php
require(dirname(__DIR__,2) . "/main.php");

$cpuCores = (int)shell_exec('nproc');

    // CPU使用率
    $cpuUsage = shell_exec("top -bn1 | grep 'Cpu(s)' | sed 's/.*, *\\([0-9.]*\\)%* id.*/\\1/'");
    $cpuUsage = 100 - (float)$cpuUsage;

    // 存储
    $diskInfo = shell_exec('df -h --total | grep total');
    preg_match_all('/[\d\.]+[GT]?/', $diskInfo, $matches);
    $totalDisk = $matches[0][0];
    $usedDisk = $matches[0][1];
    $freeDisk = $matches[0][2];
    $diskUsage = (float)$matches[0][3];

    // 内存使用率
    $memInfo = shell_exec("free | grep Mem");
    $memInfo = preg_split('/\s+/', trim($memInfo));
    $totalMem = $memInfo[1];
    $usedMem = $memInfo[2];
    $memUsage = round(($usedMem / $totalMem) * 100, 2);

    // 操作系统
    $osInfo = shell_exec('cat /etc/os-release | grep "PRETTY_NAME"');
    $osName = trim(str_replace(['PRETTY_NAME=', '"'], '', $osInfo));

    // 服务器运行时间
    $uptimeSeconds = (int)shell_exec('cat /proc/uptime | cut -d" " -f1 | cut -d"." -f1');
    $uptimeDays = floor($uptimeSeconds / 86400);
    $uptimeHours = floor(($uptimeSeconds % 86400) / 3600);
    $uptime = "{$uptimeDays}天{$uptimeHours}小时";

function BOT信息() {
	$url="https://bots.qq.com/app/getAppAccessToken";
	$appid=appid;
    $secret=secret;
	$json=json_encode(["appId"=>(string)$appid,"clientSecret"=>$secret]);
	$header=['Content-Type: application/json'];
	$fw=json_decode(curl($url,"POST",$header,$json), true);
	$Access=$fw["access_token"];
	$urls=["正式"=>"https://api.sgroup.qq.com","沙箱"=>"https://sandbox.api.sgroup.qq.com"];
	$url=$urls[type]."/users/@me";
	$hea=["Authorization: QQBot ".$Access, 'Content-Type: application/json'];
	return json_decode(curl($url,"GET",$hea,0),true);
}

function curl($url, $method, $headers, $params) {
	$url = str_replace(" ", "%20", $url);
	if (is_array($params)) {
		$requestString = http_build_query($params);
	} else {
		$requestString = $params ? : '';
	}
	if (empty($headers)) {
		$headers = array('Content-type: text/json');
	} elseif (!is_array($headers)) {
		parse_str($headers,$headers);
	}
	// setting the curl parameters.
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_VERBOSE, 1);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	// turning off the server and peer verification(TrustManager Concept).
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// setting the POST FIELD to curl
	switch ($method) {
		case "GET" : curl_setopt($ch, CURLOPT_HTTPGET, 1);
		break;
		case "POST": curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $requestString);
		break;
		case "PUT" : curl_setopt ($ch, CURLOPT_CUSTOMREQUEST, "PUT");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $requestString);
		break;
		case "DELETE":  curl_setopt ($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $requestString);
		break;
	}
	// getting response from server
	$response = curl_exec($ch);
	//close the connection
	curl_close($ch);
	//return the response
	if (stristr($response, 'HTTP 404') || $response == '') {
		return array('Error' => '请求错误');
	}
	return $response;
}

function 日志行() {
$file = dirname(__DIR__,2)."/Log/".date("Y-m-d").".log";
    if (is_file($file)) {
        return count(file($file));
    } else {
        return 0;
    }
}

function 插件() {
$file = dirname(__DIR__,2)."/plugin/*.php";
return count(glob($file));
}

function 数据统计() {
$file = dirname(__DIR__,2)."/database/事件判断/".date("Y-m-d");
    if (is_file($file)) {
        $content = file_get_contents($file);
        $json = json_decode($content,true);
        $群聊 = 0;
        $私聊 = 0;
        $加群 = 0;
        $退群 = 0;
        foreach ($json as $key => $value) {
            if (preg_match('/^([^:]+):/',$key,$matches)) {
                $type = $matches[1];
                switch ($type) {
                    case "GROUP_AT_MESSAGE_CREATE":
                        $群聊++;
                        break;
                    case "C2C_MESSAGE_CREATE":
                        $私聊++;
                        break;
                    case "GROUP_ADD_ROBOT":
                        $加群++;
                        break;
                    case "GROUP_DEL_ROBOT":
                        $退群++;
                        break;
                }
            } else {
                return false;
            }
        }
        return [
        "群聊" => $群聊,
        "私聊" => $私聊,
        "加群" => $加群,
        "退群" => $退群
        ];
    } else {
        return false;
    }
}


$BOT = BOT信息();
$data = 数据统计();
echo json_encode([
    "头像" => $BOT["avatar"],
    "昵称" => $BOT["username"],
    "账号" => appid,
    "日志行数" => 日志行(),
    "群聊" => $data["群聊"],
    "私聊" => $data["私聊"],
    "加群" => $data["加群"],
    "退群" => $data["退群"],
    "插件数量" => 插件(),
    "CPU核心数" => $cpuCores,
    "CPU使用率" => round($cpuUsage, 2),
    "总存储" => $totalDisk,
    "空闲存储" => $freeDisk,
    "使用存储" => $usedDisk,
    "存储使用率" => round($diskUsage, 2),
    "内存使用率" => $memUsage,
    "操作系统" => $osName,
    "服务器运行时间" => $uptime
],480);

